//GPT-4o-mini DATASET v1.0 Category: Searching algorithm ; Style: happy
#include <stdio.h>
#include <stdbool.h>

// Function to perform linear search
int linearSearch(int arr[], int size, int treasure) {
    printf("🔍 Searching for treasure: %d 🪙\n", treasure);
    for (int i = 0; i < size; i++) {
        printf("🌟 Checking location %d...\n", i);
        if (arr[i] == treasure) {
            printf("🎉 Treasure found at location %d! 🏆\n", i);
            return i; // Return the index where the treasure is found
        }
    }
    printf("😢 Sorry, treasure not found in our enchanted array!\n");
    return -1; // Treasure not found
}

// Function to display the array
void displayArray(int arr[], int size) {
    printf("🗺️ Here is our magical treasure map! 🗺️\n");
    for (int i = 0; i < size; i++) {
        printf("Location %d: %d\n", i, arr[i]);
    }
    printf("✨✨✨✨✨✨✨✨✨✨✨✨✨✨✨✨✨✨✨✨✨\n");
}

int main() {
    // Creating an enchanted treasure array
    int treasureArray[] = {10, 25, 33, 47, 55, 68, 82, 90, 99, 15};
    int size = sizeof(treasureArray) / sizeof(treasureArray[0]);

    // Display the magical treasure map
    displayArray(treasureArray, size);

    // Let's search for some treasures!
    int treasuresToFind[] = {15, 25, 100};
    int numTreasures = sizeof(treasuresToFind) / sizeof(treasuresToFind[0]);

    for (int i = 0; i < numTreasures; i++) {
        int treasure = treasuresToFind[i];
        int result = linearSearch(treasureArray, size, treasure);

        if (result != -1) {
            printf("🌈 Found treasure %d! Happily dancing now! 💃\n", treasure);
        } else {
            printf("😞 Treasure %d is still lost in the unknown! 🌌\n", treasure);
        }
        printf("\n"); // Adding space for clarity in the output
    }

    // Happy ending!
    printf("🌟 Thank you for joining our treasure hunt! 🌟\n");
    return 0;
}