//GEMINI-pro DATASET v1.0 Category: Geometric algorithms ; Style: protected
#include <stdlib.h>
#include <stdio.h>
#include <math.h>

typedef struct {
    double x;
    double y;
} Point;

typedef struct {
    Point p1;
    Point p2;
} Line;

typedef struct {
    Point p;
    double r;
} Circle;

// Function to calculate the distance between two points
double distance(Point p1, Point p2) {
    return sqrt((p2.x - p1.x) * (p2.x - p1.x) + (p2.y - p1.y) * (p2.y - p1.y));
}

// Function to check if a point is inside a circle
int is_inside_circle(Circle c, Point p) {
    return distance(c.p, p) < c.r;
}

// Function to check if a line intersects a circle
int does_line_intersect_circle(Line l, Circle c) {
    // Check if the line segment is inside the circle
    if (is_inside_circle(c, l.p1) && is_inside_circle(c, l.p2)) {
        return 1;
    }
    
    // Check if the line segment intersects the circle at a single point
    double d = distance(l.p1, l.p2);
    double r = c.r;
    double dist_p1_c = distance(l.p1, c.p);
    if (d == 2*r && dist_p1_c == r) {
        return 1;
    }
    
    // Check if the line segment intersects the circle at two points
    if (dist_p1_c < r && d > 2*r) {
        return 1;
    }
    
    // Otherwise, the line segment does not intersect the circle
    return 0;
}

int main() {
    // Define a circle
    Circle c1 = {{0, 0}, 5};
    
    // Define a line
    Line l1 = {{1, 1}, {3, 3}};
    
    // Check if the line intersects the circle
    int does_intersect = does_line_intersect_circle(l1, c1);
    
    // Print the result
    if (does_intersect) {
        printf("The line intersects the circle.\n");
    } else {
        printf("The line does not intersect the circle.\n");
    }
    
    return 0;
}