//GEMINI-pro DATASET v1.0 Category: Digital Auction System ; Style: single-threaded
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct {
    char name[50];
    int bid;
} Bidder;

typedef struct {
    char name[50];
    int reserve_price;
    int highest_bid;
    Bidder* highest_bidder;
} Item;

int compare_bids(const void* a, const void* b) {
    Bidder* bidder1 = (Bidder*)a;
    Bidder* bidder2 = (Bidder*)b;
    return bidder2->bid - bidder1->bid;
}

void print_bidder(Bidder* bidder) {
    printf("%s: %d\n", bidder->name, bidder->bid);
}

void print_item(Item* item) {
    printf("%s: %d (reserve price: %d)\n", item->name, item->highest_bid, item->reserve_price);
    if (item->highest_bidder != NULL) {
        printf("Highest bidder: ");
        print_bidder(item->highest_bidder);
    }
}

int main() {
    // Initialize the auction system with some items and bidders
    Item items[] = {
        {"Painting 1", 100, 0, NULL},
        {"Painting 2", 200, 0, NULL},
        {"Sculpture 1", 300, 0, NULL},
    };
    int num_items = sizeof(items) / sizeof(Item);

    Bidder bidders[] = {
        {"Alice", 150},
        {"Bob", 250},
        {"Carol", 350},
    };
    int num_bidders = sizeof(bidders) / sizeof(Bidder);

    // Sort the bidders in descending order of their bids
    qsort(bidders, num_bidders, sizeof(Bidder), compare_bids);

    // Iterate over the items and process the bids
    for (int i = 0; i < num_items; i++) {
        Item* item = &items[i];

        // Iterate over the bidders and find the highest bid for the item
        for (int j = 0; j < num_bidders; j++) {
            Bidder* bidder = &bidders[j];

            // If the bidder's bid is higher than the current highest bid and meets the reserve price, update the highest bid
            if (bidder->bid > item->highest_bid && bidder->bid >= item->reserve_price) {
                item->highest_bid = bidder->bid;
                item->highest_bidder = bidder;
            }
        }

        // Print the item and its highest bid
        print_item(item);
    }

    return 0;
}