//Falcon-180B DATASET v1.0 Category: System boot optimizer ; Style: future-proof
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PROCESSES 100
#define MAX_COMMAND_LENGTH 256

typedef struct {
    char command[MAX_COMMAND_LENGTH];
    int priority;
} Process;

void addProcess(Process *processes, int numProcesses, char *command, int priority) {
    if (numProcesses >= MAX_PROCESSES) {
        printf("Error: Too many processes\n");
        exit(1);
    }

    strcpy(processes[numProcesses].command, command);
    processes[numProcesses].priority = priority;

    numProcesses++;
}

void sortProcesses(Process *processes, int numProcesses) {
    for (int i = 0; i < numProcesses - 1; i++) {
        for (int j = i + 1; j < numProcesses; j++) {
            if (processes[i].priority > processes[j].priority) {
                Process temp = processes[i];
                processes[i] = processes[j];
                processes[j] = temp;
            }
        }
    }
}

void executeProcesses(Process *processes, int numProcesses) {
    for (int i = 0; i < numProcesses; i++) {
        printf("Executing process %s with priority %d\n", processes[i].command, processes[i].priority);
    }
}

int main() {
    Process processes[MAX_PROCESSES];
    int numProcesses = 0;

    addProcess(processes, numProcesses, "ls", 10);
    addProcess(processes, numProcesses, "grep foo", 20);
    addProcess(processes, numProcesses, "sort", 30);
    addProcess(processes, numProcesses, "awk '{print $1}'", 40);

    sortProcesses(processes, numProcesses);
    executeProcesses(processes, numProcesses);

    return 0;
}