//GPT-4o-mini DATASET v1.0 Category: Simulation of the Solar System ; Style: detailed
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <unistd.h>

#define NUM_PLANETS 8
#define PI 3.14159

typedef struct {
    char name[20];
    float distance;  // Distance from the sun in astronomical units (AU)
    float orbitalPeriod;  // Orbital period in Earth days
    float angle;  // Current angle in radians
} Planet;

Planet planets[NUM_PLANETS] = {
    {"Mercury", 0.39, 88.0, 0.0},
    {"Venus", 0.72, 225.0, 0.0},
    {"Earth", 1.0, 365.0, 0.0},
    {"Mars", 1.52, 687.0, 0.0},
    {"Jupiter", 5.2, 4333.0, 0.0},
    {"Saturn", 9.58, 10759.0, 0.0},
    {"Uranus", 19.22, 30688.0, 0.0},
    {"Neptune", 30.05, 60182.0, 0.0}
};

void updatePlanetsPositions() {
    for (int i = 0; i < NUM_PLANETS; i++) {
        // Update the angle based on the orbital period 
        planets[i].angle += (2 * PI) / (planets[i].orbitalPeriod / 365.0);
        if (planets[i].angle >= 2 * PI) {
            planets[i].angle -= 2 * PI;  // Keep angle within bounds
        }
    }
}

void printSolarSystem() {
    printf("Solar System Simulation\n");
    printf("========================\n");
    for (int i = 0; i < NUM_PLANETS; i++) {
        float x = planets[i].distance * cos(planets[i].angle);
        float y = planets[i].distance * sin(planets[i].angle);
        printf("%s: (Distance: %.2f AU, Position: (%.2f, %.2f))\n", 
                planets[i].name, planets[i].distance, x, y);
    }
    printf("\n\n");
}

int main() {
    int cycles = 5;  // Number of simulation cycles
    int delay = 1;   // Delay between each cycle (in seconds)

    for (int cycle = 0; cycle < cycles; cycle++) {
        printSolarSystem();  // Print the current positions of planets
        updatePlanetsPositions();  // Update positions for the next cycle
        sleep(delay);  // Wait for a second before updating
    }

    return 0;
}