//Falcon-180B DATASET v1.0 Category: Subnet Calculator ; Style: authentic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SUBNETS 100

struct subnet {
    char name[20];
    char ip[16];
    char netmask[16];
    char gateway[16];
    char dns[16];
};

void add_subnet(struct subnet *subnets, int num_subnets, char *name, char *ip, char *netmask, char *gateway, char *dns) {
    if (num_subnets >= MAX_SUBNETS) {
        printf("Error: Maximum number of subnets reached.\n");
        return;
    }

    strcpy(subnets[num_subnets].name, name);
    strcpy(subnets[num_subnets].ip, ip);
    strcpy(subnets[num_subnets].netmask, netmask);
    strcpy(subnets[num_subnets].gateway, gateway);
    strcpy(subnets[num_subnets].dns, dns);

    num_subnets++;
}

void print_subnets(struct subnet *subnets, int num_subnets) {
    printf("Subnets:\n");
    for (int i = 0; i < num_subnets; i++) {
        printf("Name: %s\n", subnets[i].name);
        printf("IP: %s\n", subnets[i].ip);
        printf("Netmask: %s\n", subnets[i].netmask);
        printf("Gateway: %s\n", subnets[i].gateway);
        printf("DNS: %s\n", subnets[i].dns);
        printf("\n");
    }
}

int main() {
    struct subnet subnets[MAX_SUBNETS];
    int num_subnets = 0;

    add_subnet(subnets, num_subnets, "Subnet 1", "192.168.1.0", "255.255.255.0", "192.168.1.1", "8.8.8.8");
    add_subnet(subnets, num_subnets, "Subnet 2", "10.0.0.0", "255.0.0.0", "10.0.0.1", "8.8.4.4");
    add_subnet(subnets, num_subnets, "Subnet 3", "172.16.0.0", "255.240.0.0", "172.16.0.1", "8.8.8.8");

    print_subnets(subnets, num_subnets);

    return 0;
}