//GEMINI-pro DATASET v1.0 Category: Client Server Application ; Style: rigorous
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>

#define PORT 8080

int main(int argc, char *argv[]) {
    int sockfd, newsockfd;
    struct sockaddr_in serv_addr, cli_addr;
    int n;
    char buffer[256];

    // Create a socket
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) {
        perror("ERROR opening socket");
        exit(1);
    }

    // Set up the server address
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_addr.s_addr = INADDR_ANY;
    serv_addr.sin_port = htons(PORT);

    // Bind the socket to the server address
    if (bind(sockfd, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) < 0) {
        perror("ERROR on binding");
        exit(1);
    }

    // Listen for incoming connections
    listen(sockfd, 5);

    // Accept an incoming connection
    newsockfd = accept(sockfd, (struct sockaddr *) &cli_addr, (socklen_t *) sizeof(cli_addr));
    if (newsockfd < 0) {
        perror("ERROR on accept");
        exit(1);
    }

    // Read data from the client
    n = read(newsockfd, buffer, 255);
    if (n < 0) {
        perror("ERROR reading from socket");
        exit(1);
    }

    // Write data to the client
    n = write(newsockfd, "Hello, client!", 14);
    if (n < 0) {
        perror("ERROR writing to socket");
        exit(1);
    }

    // Close the client socket
    close(newsockfd);

    // Close the server socket
    close(sockfd);

    return 0;
}