//Gemma-7B DATASET v1.0 Category: Electronic Voting System ; Style: cheerful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAX_CANDIDATES 5
#define MAX_VOTES 100

typedef struct Candidate {
  char name[20];
  int votes;
} Candidate;

Candidate candidates[MAX_CANDIDATES];

void initializeCandidates() {
  for (int i = 0; i < MAX_CANDIDATES; i++) {
    candidates[i].name[0] = '\0';
    candidates[i].votes = 0;
  }
}

void addVote(char candidateName) {
  for (int i = 0; i < MAX_CANDIDATES; i++) {
    if (strcmp(candidates[i].name, candidateName) == 0) {
      candidates[i].votes++;
      return;
    }
  }

  // Candidate not found, add new candidate
  Candidate newCandidate;
  strcpy(newCandidate.name, candidateName);
  newCandidate.votes = 1;
  candidates[MAX_CANDIDATES - 1] = newCandidate;
}

void printResults() {
  int maxVotes = candidates[0].votes;
  for (int i = 1; i < MAX_CANDIDATES; i++) {
    if (candidates[i].votes > maxVotes) {
      maxVotes = candidates[i].votes;
    }
  }

  printf("The winner is: ");
  for (int i = 0; i < MAX_CANDIDATES; i++) {
    if (candidates[i].votes == maxVotes) {
      printf("%s\n", candidates[i].name);
    }
  }
}

int main() {
  initializeCandidates();

  // Simulate some votes
  addVote("John Doe");
  addVote("Jane Doe");
  addVote("Bill Smith");
  addVote("Mary Johnson");
  addVote("John Doe");

  // Print the results
  printResults();

  return 0;
}