//LLAMA2-13B DATASET v1.0 Category: Socket programming ; Style: happy
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define PORT 8080

int main() {
  int sock;
  struct sockaddr_in server_address;
  char buffer[256];
  int recv_len = 0;

  // Create a socket
  sock = socket(AF_INET, SOCK_STREAM, 0);
  if (sock < 0) {
    perror("Socket creation failed");
    exit(1);
  }

  // Set up the server address
  server_address.sin_family = AF_INET;
  server_address.sin_addr.s_addr = INADDR_ANY;
  server_address.sin_port = htons(PORT);

  // Bind the socket to the address and port
  if (bind(sock, (struct sockaddr *)&server_address, sizeof(server_address)) < 0) {
    perror("Binding failed");
    exit(1);
  }

  // Listen for incoming connections
  if (listen(sock, 3) < 0) {
    perror("Listening failed");
    exit(1);
  }

  printf("Server listening on port %d...\n", PORT);

  // Accept an incoming connection
  sock = accept(sock, NULL, NULL);
  if (sock < 0) {
    perror("Accept failed");
    exit(1);
  }

  // Read data from the client
  recv_len = recv(sock, buffer, 256, 0);
  if (recv_len < 0) {
    perror("Recv failed");
    exit(1);
  }

  // Print the received message
  printf("Received message: %s\n", buffer);

  // Send a response back to the client
  char *message = "Hello, happy client!";
  send(sock, message, strlen(message), 0);

  // Close the socket
  close(sock);

  return 0;
}