//GEMINI-pro DATASET v1.0 Category: Product Inventory System ; Style: genius
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>

#define MAX_PRODUCTS 100

typedef struct {
  int id;
  char name[50];
  float price;
  int quantity;
} Product;

Product products[MAX_PRODUCTS];
int num_products = 0;

// Function to add a new product to the inventory
void add_product(Product product) {
  if (num_products >= MAX_PRODUCTS) {
    printf("Error: Product inventory is full.\n");
    return;
  }

  products[num_products++] = product;
}

// Function to search for a product by its ID
Product* find_product_by_id(int id) {
  for (int i = 0; i < num_products; i++) {
    if (products[i].id == id) {
      return &products[i];
    }
  }

  return NULL;
}

// Function to print the inventory
void print_inventory() {
  printf("Product Inventory:\n");
  for (int i = 0; i < num_products; i++) {
    printf("%d. %s - $%.2f - %d units\n", products[i].id, products[i].name, products[i].price, products[i].quantity);
  }
}

// Function to sell a product
bool sell_product(int id, int quantity) {
  Product* product = find_product_by_id(id);
  if (product == NULL) {
    printf("Error: Product not found.\n");
    return false;
  }

  if (product->quantity < quantity) {
    printf("Error: Insufficient product quantity.\n");
    return false;
  }

  product->quantity -= quantity;
  printf("%d units of %s sold.\n", quantity, product->name);
  return true;
}

// Function to replenish a product's stock
bool replenish_product(int id, int quantity) {
  Product* product = find_product_by_id(id);
  if (product == NULL) {
    printf("Error: Product not found.\n");
    return false;
  }

  product->quantity += quantity;
  printf("%d units of %s replenished.\n", quantity, product->name);
  return true;
}

int main() {
  // Initialize the inventory with some sample products
  add_product((Product) {1, "Apple", 0.50, 10});
  add_product((Product) {2, "Banana", 0.75, 12});
  add_product((Product) {3, "Orange", 1.00, 15});
  add_product((Product) {4, "Grape", 1.25, 13});
  add_product((Product) {5, "Strawberry", 1.50, 10});

  // Print the inventory
  print_inventory();

  // Sell some products
  sell_product(1, 5);
  sell_product(3, 3);

  // Replenish some products
  replenish_product(2, 4);
  replenish_product(4, 5);

  // Print the inventory again
  print_inventory();

  return 0;
}