//GPT-4o-mini DATASET v1.0 Category: Weather simulation ; Style: energetic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Function prototypes
void generateWeatherReport();
const char* getWeatherCondition(int temperature, int humidity);

int main() {
    // Seed the random number generator
    srand(time(NULL));
    
    printf("🌞 Welcome to the C Weather Simulation! 🌧️\n");
    printf("Generating your weather report...\n\n");

    // Generating a weather report
    generateWeatherReport();

    return 0;
}

void generateWeatherReport() {
    // Define weather variables
    int temperature = rand() % 41 - 10; // Temperature between -10 to 30 degrees Celsius
    int humidity = rand() % 101;         // Humidity between 0 to 100 percent
    int windSpeed = rand() % 101;        // Wind speed between 0 to 100 km/h

    // Get weather condition description
    const char* condition = getWeatherCondition(temperature, humidity);

    // Print the weather report
    printf("🌡️ Temperature: %d °C\n", temperature);
    printf("💧 Humidity: %d%%\n", humidity);
    printf("💨 Wind Speed: %d km/h\n", windSpeed);
    printf("📊 Weather Condition: %s\n\n", condition);
    
    // Display a motivational quote regarding the weather
    printf("✨ Be the sunshine on a cloudy day! ✨\n");
}

const char* getWeatherCondition(int temperature, int humidity) {
    // Determine weather condition based on temperature and humidity
    if (temperature < 0) {
        return "Freezing!";
    } else if (temperature >= 0 && temperature <= 20) {
        if (humidity > 80) {
            return "Chilly and Humid!";
        } else {
            return "Cool and Pleasant!";
        }
    } else if (temperature > 20 && temperature <= 30) {
        if (humidity > 60) {
            return "Warm and Sticky!";
        } else {
            return "Sunny and Nice!";
        }
    } else {
        if (humidity < 50) {
            return "Scorching Hot!";
        } else {
            return "Sweltering and Humid!";
        }
    }
}