//GEMINI-pro DATASET v1.0 Category: Intrusion detection system ; Style: light-weight
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

// Define the maximum number of events to store
#define MAX_EVENTS 100

// Define the structure of an event
typedef struct {
    time_t time;
    char *source;
    char *destination;
    int port;
    char *protocol;
} event;

// Create an array of events
event events[MAX_EVENTS];

// Initialize the number of events to 0
int num_events = 0;

// Add an event to the array
void add_event(event *e) {
    // Check if the array is full
    if (num_events == MAX_EVENTS) {
        // If the array is full, shift all the events to the left
        for (int i = 0; i < num_events - 1; i++) {
            events[i] = events[i + 1];
        }

        // Decrement the number of events
        num_events--;
    }

    // Add the new event to the array
    events[num_events] = *e;

    // Increment the number of events
    num_events++;
}

// Print the events in the array
void print_events() {
    for (int i = 0; i < num_events; i++) {
        printf("%s %s %s %d %s\n", ctime(&events[i].time), events[i].source, events[i].destination, events[i].port, events[i].protocol);
    }
}

// Check if an event is suspicious
int is_suspicious(event *e) {
    // Check if the source is a known attacker
    if (strcmp(e->source, "attacker.com") == 0) {
        return 1;
    }

    // Check if the destination is a known target
    if (strcmp(e->destination, "target.com") == 0) {
        return 1;
    }

    // Check if the port is a known exploit port
    if (e->port == 445 || e->port == 139 || e->port == 443) {
        return 1;
    }

    // Check if the protocol is a known exploit protocol
    if (strcmp(e->protocol, "TCP") == 0 || strcmp(e->protocol, "UDP") == 0) {
        return 1;
    }

    // Otherwise, the event is not suspicious
    return 0;
}

// Main function
int main() {
    // Create a new event
    event e;

    // Set the event's time
    e.time = time(NULL);

    // Set the event's source
    e.source = "attacker.com";

    // Set the event's destination
    e.destination = "target.com";

    // Set the event's port
    e.port = 443;

    // Set the event's protocol
    e.protocol = "TCP";

    // Add the event to the array
    add_event(&e);

    // Print the events in the array
    print_events();

    // Check if the event is suspicious
    if (is_suspicious(&e)) {
        printf("The event is suspicious!\n");
    } else {
        printf("The event is not suspicious.\n");
    }

    return 0;
}