//Falcon-180B DATASET v1.0 Category: Airport Baggage Handling Simulation ; Style: light-weight
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_BAGS 100
#define NUM_DESTINATIONS 10
#define BAG_SIZE 50

struct bag {
    int id;
    int destination;
};

int main() {
    struct bag bags[NUM_BAGS];
    int i;

    // Initialize bags
    for (i = 0; i < NUM_BAGS; i++) {
        bags[i].id = i + 1;
        bags[i].destination = rand() % NUM_DESTINATIONS + 1;
    }

    // Shuffle bags
    for (i = 0; i < NUM_BAGS; i++) {
        int j = rand() % NUM_BAGS;
        struct bag temp = bags[i];
        bags[i] = bags[j];
        bags[j] = temp;
    }

    // Print initial state of bags
    printf("Initial state of bags:\n");
    for (i = 0; i < NUM_BAGS; i++) {
        printf("Bag %d is destined for location %d\n", bags[i].id, bags[i].destination);
    }

    // Simulate baggage handling
    for (i = 0; i < NUM_BAGS; i++) {
        if (bags[i].destination == 1) {
            printf("Bag %d has been loaded onto the plane for destination 1\n", bags[i].id);
        } else if (bags[i].destination == 2) {
            printf("Bag %d has been loaded onto the plane for destination 2\n", bags[i].id);
        } else {
            printf("Bag %d has been loaded onto the plane for an unknown destination\n", bags[i].id);
        }
    }

    return 0;
}