//Gemma-7B DATASET v1.0 Category: Percolation Simulator ; Style: minimalist
#include <stdio.h>
#include <stdlib.h>

#define MAX 10

int main()
{
    int board[MAX][MAX] = {0};
    int x, y, p, i, j;

    // Percolation Probability
    p = rand() % 20 + 1;

    // Generate Random Matrix
    for (i = 0; i < MAX; i++)
    {
        for (j = 0; j < MAX; j++)
        {
            board[i][j] = rand() % p == 0 ? 1 : 0;
        }
    }

    // Check if Percolation
    for (i = 0; i < MAX; i++)
    {
        for (j = 0; j < MAX; j++)
        {
            if (board[i][j] == 1)
            {
                // Check Left
                if (i > 0 && board[i - 1][j] == 1)
                {
                    board[i][j] = 2;
                }
                // Check Right
                if (i < MAX - 1 && board[i + 1][j] == 1)
                {
                    board[i][j] = 2;
                }
                // Check Up
                if (j > 0 && board[i][j - 1] == 1)
                {
                    board[i][j] = 2;
                }
                // Check Down
                if (j < MAX - 1 && board[i][j + 1] == 1)
                {
                    board[i][j] = 2;
                }
            }
        }
    }

    // Print the Result
    for (i = 0; i < MAX; i++)
    {
        for (j = 0; j < MAX; j++)
        {
            printf("%d ", board[i][j]);
        }
        printf("\n");
    }

    return 0;
}