//Falcon-180B DATASET v1.0 Category: Remote control Vehicle Simulation ; Style: Romeo and Juliet
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the vehicle's speed and direction
#define SPEED 5
#define LEFT 1
#define RIGHT 2
#define FORWARD 3
#define BACKWARD 4

// Define the remote control buttons
#define BUTTON_UP 1
#define BUTTON_DOWN 2
#define BUTTON_LEFT 3
#define BUTTON_RIGHT 4
#define BUTTON_STOP 5

// Define the vehicle's position and orientation
int x, y;
int direction;

// Function to move the vehicle
void move_vehicle(int dx, int dy) {
    x += dx;
    y += dy;
}

// Function to change the vehicle's direction
void change_direction(int new_direction) {
    direction = new_direction;
}

// Function to stop the vehicle
void stop_vehicle() {
    direction = 0;
}

// Function to handle remote control button presses
void handle_button_press(int button) {
    switch (button) {
        case BUTTON_UP:
            move_vehicle(0, -SPEED);
            break;
        case BUTTON_DOWN:
            move_vehicle(0, SPEED);
            break;
        case BUTTON_LEFT:
            move_vehicle(-SPEED, 0);
            change_direction(LEFT);
            break;
        case BUTTON_RIGHT:
            move_vehicle(SPEED, 0);
            change_direction(RIGHT);
            break;
        case BUTTON_STOP:
            stop_vehicle();
            break;
        default:
            printf("Invalid button press\n");
            break;
    }
}

// Function to generate a random remote control button press
int generate_button_press() {
    int button;
    srand(time(NULL));
    button = rand() % 5;
    return button;
}

// Main function
int main() {
    int button;
    int i;

    // Initialize the vehicle's position and direction
    x = 0;
    y = 0;
    direction = FORWARD;

    // Simulate remote control button presses
    for (i = 0; i < 10; i++) {
        button = generate_button_press();
        handle_button_press(button);
        printf("Vehicle position: (%d, %d)\n", x, y);
        printf("Vehicle direction: %d\n", direction);
        printf("\n");
    }

    return 0;
}