//GPT-4o-mini DATASET v1.0 Category: Stock market tracker ; Style: decentralized
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_STOCKS 100
#define MAX_SYMBOL_LENGTH 10
#define MAX_PORTFOLIO_SIZE 10

typedef struct {
    char symbol[MAX_SYMBOL_LENGTH];
    float price;
} Stock;

typedef struct {
    char symbol[MAX_SYMBOL_LENGTH];
    int quantity;
} PortfolioItem;

typedef struct {
    PortfolioItem items[MAX_PORTFOLIO_SIZE];
    int size;
} Portfolio;

Stock stocks[MAX_STOCKS];
int stockCount = 0;

void addStock(const char *symbol, float price) {
    if (stockCount < MAX_STOCKS) {
        strcpy(stocks[stockCount].symbol, symbol);
        stocks[stockCount].price = price;
        stockCount++;
    } else {
        printf("Stock limit reached!\n");
    }
}

void updateStockPrice(const char *symbol, float newPrice) {
    for (int i = 0; i < stockCount; i++) {
        if (strcmp(stocks[i].symbol, symbol) == 0) {
            stocks[i].price = newPrice;
            printf("Updated %s to new price: %.2f\n", symbol, newPrice);
            return;
        }
    }
    printf("Stock %s not found!\n", symbol);
}

void viewStocks() {
    printf("Available Stocks:\n");
    for (int i = 0; i < stockCount; i++) {
        printf("Symbol: %s, Price: %.2f\n", stocks[i].symbol, stocks[i].price);
    }
}

void buyStock(Portfolio *portfolio, const char *symbol, int quantity) {
    for (int i = 0; i < portfolio->size; i++) {
        if (strcmp(portfolio->items[i].symbol, symbol) == 0) {
            portfolio->items[i].quantity += quantity;
            printf("Bought %d of %s. New quantity: %d\n", quantity, symbol, portfolio->items[i].quantity);
            return;
        }
    }
    if (portfolio->size < MAX_PORTFOLIO_SIZE) {
        strcpy(portfolio->items[portfolio->size].symbol, symbol);
        portfolio->items[portfolio->size].quantity = quantity;
        portfolio->size++;
        printf("Bought %d of %s and added to portfolio.\n", quantity, symbol);
    } else {
        printf("Portfolio limit reached!\n");
    }
}

void sellStock(Portfolio *portfolio, const char *symbol, int quantity) {
    for (int i = 0; i < portfolio->size; i++) {
        if (strcmp(portfolio->items[i].symbol, symbol) == 0) {
            if (portfolio->items[i].quantity >= quantity) {
                portfolio->items[i].quantity -= quantity;
                printf("Sold %d of %s. Remaining quantity: %d\n", quantity, symbol, portfolio->items[i].quantity);
                if (portfolio->items[i].quantity == 0) {
                    // Remove from portfolio
                    for (int j = i; j < portfolio->size - 1; j++) {
                        portfolio->items[j] = portfolio->items[j + 1];
                    }
                    portfolio->size--;
                }
                return;
            } else {
                printf("Not enough shares to sell!\n");
                return;
            }
        }
    }
    printf("Stock %s not found in portfolio!\n", symbol);
}

void viewPortfolio(Portfolio *portfolio) {
    printf("Your Portfolio:\n");
    for (int i = 0; i < portfolio->size; i++) {
        printf("Symbol: %s, Quantity: %d\n", portfolio->items[i].symbol, portfolio->items[i].quantity);
    }
}

int main() {
    Portfolio myPortfolio = {.size = 0};
    
    addStock("AAPL", 145.30);
    addStock("GOOGL", 2730.00);
    addStock("AMZN", 3342.88);
    
    viewStocks();

    buyStock(&myPortfolio, "AAPL", 10);
    buyStock(&myPortfolio, "GOOGL", 5);
    
    viewPortfolio(&myPortfolio);
    
    sellStock(&myPortfolio, "AAPL", 3);
    viewPortfolio(&myPortfolio);
    
    updateStockPrice("AAPL", 150.00);
    viewStocks();
    
    return 0;
}