//GEMINI-pro DATASET v1.0 Category: Alien Language Translator ; Style: authentic
// Galactic Language Translation Terminal 🛸

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

// Alien Languages Dictionary
char *alien_dict[] = {
    "Grug", "Earthling",
    "Greeble", "Martian",
    "Zogwort", "Venusian",
    "Pleeple", "Jupiterian",
    "Snerf", "Saturnian",
    "Flarb", "Uranian",
    "Blorf", "Neptunian"
};

// Function to search for Alien Language in Dictionary
int find_alien_language(char *alien_word) {
    for (int i = 0; i < sizeof(alien_dict) / sizeof(char *); i += 2) {
        if (strcmp(alien_word, alien_dict[i]) == 0) {
            return i / 2;
        }
    }
    return -1;
}

// Function to translate Alien Word to English
char *translate_alien_word(char *alien_word) {
    int alien_index = find_alien_language(alien_word);
    if (alien_index != -1) {
        return alien_dict[alien_index + 1];
    }
    return "Unknown Alien Language";
}

// Function to print Alien Word Translation
void print_translation(char *alien_word) {
    char *translation = translate_alien_word(alien_word);
    printf("Alien Word: %s\n", alien_word);
    printf("Translation: %s\n", translation);
}

int main() {
    // Initialize Alien Language Phrases
    char *phrases[] = {
        "Grug blarf ooga",
        "Greeble zogwort pleeble",
        "Zogwort snerf flarb",
        "Pleeple blorf greebly",
        "Snerf zogwort greeble"
    };

    // Translate and Print Alien Phrases
    for (int i = 0; i < sizeof(phrases) / sizeof(char *); i++) {
        print_translation(phrases[i]);
        printf("\n");
    }

    return 0;
}