//Falcon-180B DATASET v1.0 Category: File system simulation ; Style: introspective
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_FILES 100
#define MAX_FILE_NAME_LENGTH 50
#define MAX_FILE_SIZE 1024

typedef struct {
    char name[MAX_FILE_NAME_LENGTH];
    int size;
    char data[MAX_FILE_SIZE];
} file_t;

file_t files[MAX_FILES];

int num_files = 0;

void create_file(char* name, int size) {
    if (num_files >= MAX_FILES) {
        printf("Error: Maximum number of files reached.\n");
        return;
    }

    strcpy(files[num_files].name, name);
    files[num_files].size = size;

    printf("File created: %s\n", name);

    num_files++;
}

void delete_file(char* name) {
    int i;

    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, name) == 0) {
            printf("File deleted: %s\n", name);

            memset(&files[i], 0, sizeof(file_t));

            num_files--;

            return;
        }
    }

    printf("File not found: %s\n", name);
}

void write_to_file(char* name, char* data, int size) {
    int i;

    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, name) == 0) {
            if (size > files[i].size) {
                printf("Error: Data too large for file.\n");
                return;
            }

            strcpy(files[i].data, data);

            printf("Data written to file: %s\n", name);

            return;
        }
    }

    printf("File not found: %s\n", name);
}

void read_from_file(char* name) {
    int i;

    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, name) == 0) {
            printf("Data read from file: %s\n", name);
            printf("%s", files[i].data);

            return;
        }
    }

    printf("File not found: %s\n", name);
}

int main() {
    create_file("test.txt", 10);
    write_to_file("test.txt", "Hello, world!", 13);
    read_from_file("test.txt");
    delete_file("test.txt");

    return 0;
}