//MISTRAL-7B DATASET v1.0 Category: Arithmetic ; Style: relaxed
/*
 * This program calculates the sum of two matrices using some
 * creative arithmetic. Let's call this Matrix Addition on Steroids!
 */

#include <stdio.h>
#define ROWS 3
#define COLS 3

/*
 * Define two matrices A and B and initialize them with some random values.
 */
int A[ROWS][COLS] = { {1, 2, 3}, {4, 5, 6}, {7, 8, 9} };
int B[ROWS][COLS] = { {10, 11, 12}, {13, 14, 15}, {16, 17, 18} };

/*
 * Define a third matrix C to store the sum of matrices A and B.
 */
int C[ROWS][COLS];

/*
 * Calculate the sum of two matrices using some creative arithmetic.
 */
void addMatrices(int m[][COLS], int n[][COLS], int p[][COLS], int rows, int cols) {
    for (int i = 0; i < rows; i++) {
        for (int j = 0; j < cols; j++) {
            /*
             * Add the corresponding elements of matrices A and B with some
             * creative arithmetic and store the result in matrix C.
             */
            C[i][j] = m[i][j] + n[i][j] + (2 * (m[i][j] > n[i][j] ? m[i][j] : n[i][j]));
        }
    }
}

/*
 * Print the contents of matrices A, B, and C.
 */
void printMatrices(const char* name, int m[][COLS], int rows, int cols) {
    printf("\n%s:\n", name);
    for (int i = 0; i < rows; i++) {
        for (int j = 0; j < cols; j++) {
            printf("%d ", m[i][j]);
        }
        printf("\n");
    }
}

/*
 * Entry point of the program.
 */
int main() {
    addMatrices(A, B, C, ROWS, COLS);
    printMatrices("Matrix A: ", A, ROWS, COLS);
    printMatrices("Matrix B: ", B, ROWS, COLS);
    printMatrices("Matrix C (sum of A and B): ", C, ROWS, COLS);

    return 0;
}