//Falcon-180B DATASET v1.0 Category: Dice Roller ; Style: Romeo and Juliet
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Function to generate a random number between 1 and 6 (inclusive)
int rollDice() {
    return rand() % 6 + 1;
}

// Function to print the result of a dice roll
void printResult(int result) {
    if (result == 1) {
        printf("You rolled a 1! Better luck next time.\n");
    } else if (result == 6) {
        printf("You rolled a 6! Congratulations!\n");
    } else {
        printf("You rolled a %d.\n", result);
    }
}

int main() {
    srand(time(0)); // Seed the random number generator with the current time

    // Romeo and Juliet style dialogue
    printf("Romeo: Fair Juliet, let us play a game of chance.\n");
    printf("Juliet: Aye, my love, but what shall be the stakes?\n");
    printf("Romeo: The winner shall receive a kiss from the other.\n");
    printf("Juliet: Agreed! Let us begin.\n");

    // Play the game
    int romeoRoll, julietRoll;
    int rounds = 3;
    int romeoWins = 0;
    int julietWins = 0;

    for (int i = 0; i < rounds; i++) {
        romeoRoll = rollDice();
        julietRoll = rollDice();

        printf("Round %d:\n", i+1);
        printf("Romeo rolls a %d...\n", romeoRoll);
        printf("Juliet rolls a %d...\n", julietRoll);

        if (romeoRoll > julietRoll) {
            printf("Romeo wins this round!\n");
            romeoWins++;
        } else if (julietRoll > romeoRoll) {
            printf("Juliet wins this round!\n");
            julietWins++;
        } else {
            printf("It's a tie.\n");
        }

        printResult(romeoRoll);
        printResult(julietRoll);
    }

    // Determine the overall winner
    if (romeoWins > julietWins) {
        printf("\nRomeo is the overall winner! He receives a kiss from Juliet.\n");
    } else if (julietWins > romeoWins) {
        printf("\nJuliet is the overall winner! She receives a kiss from Romeo.\n");
    } else {
        printf("\nIt's a tie. Both Romeo and Juliet receive kisses from each other.\n");
    }

    return 0;
}