//GEMINI-pro DATASET v1.0 Category: Greedy Algorithms ; Style: authentic
#include <stdio.h>
#include <stdlib.h>

// A custom data structure to represent an activity.
typedef struct Activity {
    int start;
    int finish;
} Activity;

// A comparison function to sort activities in ascending order of finish time.
int cmp(const void *a, const void *b) {
    Activity *aa = (Activity *)a;
    Activity *bb = (Activity *)b;
    return aa->finish - bb->finish;
}

// A greedy algorithm to find the maximum number of activities that can be performed.
int activitySelection(Activity *activities, int n) {
    // Sort the activities in ascending order of finish time.
    qsort(activities, n, sizeof(Activity), cmp);

    // Initialize the count of selected activities.
    int count = 1;

    // Initialize the last selected activity.
    Activity last = activities[0];

    // Iterate over the remaining activities.
    for (int i = 1; i < n; i++) {
        // If the current activity starts after the finish time of the last selected activity, select it.
        if (activities[i].start >= last.finish) {
            count++;
            last = activities[i];
        }
    }

    // Return the count of selected activities.
    return count;
}

// A simple test function.
int main() {
    // Create an array of activities.
    Activity activities[] = {
        {0, 6},
        {1, 4},
        {2, 5},
        {3, 7},
        {4, 8},
        {5, 9},
        {6, 10},
        {7, 11},
        {8, 12},
        {9, 13}
    };

    // Get the number of activities.
    int n = sizeof(activities) / sizeof(Activity);

    // Find the maximum number of activities that can be performed.
    int count = activitySelection(activities, n);

    // Print the count of selected activities.
    printf("The maximum number of activities that can be performed is: %d\n", count);

    return 0;
}