//Falcon-180B DATASET v1.0 Category: Encryption ; Style: all-encompassing
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define KEY_LENGTH 16
#define BLOCK_SIZE 8

void generate_key(char *key) {
    for (int i = 0; i < KEY_LENGTH; i++) {
        key[i] = rand() % 26 + 'a';
    }
    key[KEY_LENGTH] = '\0';
}

void encrypt(char *message, char *key) {
    int message_length = strlen(message);
    int key_index = 0;
    char encrypted_message[message_length + 1];

    for (int i = 0; i < message_length; i++) {
        if (isalpha(message[i])) {
            char letter = toupper(message[i]);
            letter = letter + key[key_index % KEY_LENGTH];
            key_index++;
            encrypted_message[i] = letter;
        } else {
            encrypted_message[i] = message[i];
        }
    }
    encrypted_message[message_length] = '\0';
    printf("Encrypted message: %s\n", encrypted_message);
}

void decrypt(char *message, char *key) {
    int message_length = strlen(message);
    int key_index = 0;
    char decrypted_message[message_length + 1];

    for (int i = 0; i < message_length; i++) {
        if (isalpha(message[i])) {
            char letter = toupper(message[i]);
            letter = letter - key[key_index % KEY_LENGTH] + 'A';
            key_index++;
            decrypted_message[i] = letter;
        } else {
            decrypted_message[i] = message[i];
        }
    }
    decrypted_message[message_length] = '\0';
    printf("Decrypted message: %s\n", decrypted_message);
}

int main() {
    char message[100] = "Hello, world! ";
    char key[KEY_LENGTH + 1] = "";

    generate_key(key);

    printf("Key: %s\n", key);
    encrypt(message, key);
    decrypt(message, key);

    return 0;
}