//GPT-4o-mini DATASET v1.0 Category: Log analysis ; Style: detailed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAX_LOG_SIZE 1024
#define MAX_LOG_ENTRIES 100
#define TIME_FORMAT "%Y-%m-%d %H:%M:%S"

// Struct to hold individual log entries
typedef struct {
    char timestamp[20];
    char level[10];
    char message[MAX_LOG_SIZE];
} LogEntry;

// Log structure to hold the collection of log entries
typedef struct {
    LogEntry entries[MAX_LOG_ENTRIES];
    int count;
} Log;

// Function prototypes
void add_log_entry(Log *log, const char *level, const char *message);
void print_logs(const Log *log);
void filter_logs_by_level(const Log *log, const char *level);

int main() {
    Log log = { .count = 0 };
    
    // Adding log entries to our log
    add_log_entry(&log, "INFO", "Program started successfully.");
    add_log_entry(&log, "DEBUG", "Initializing variables.");
    add_log_entry(&log, "ERROR", "An error occurred while loading the configuration.");
    add_log_entry(&log, "INFO", "Configuration loaded successfully.");
    add_log_entry(&log, "WARNING", "Low memory warning.");
    add_log_entry(&log, "INFO", "Program finished processing data.");
    add_log_entry(&log, "DEBUG", "Entering shutdown sequence.");
    
    printf("All Log Entries:\n");
    print_logs(&log);
    
    printf("\nFiltered by ERROR Level:\n");
    filter_logs_by_level(&log, "ERROR");
    
    printf("\nFiltered by INFO Level:\n");
    filter_logs_by_level(&log, "INFO");
    
    return 0;
}

// Function to add a log entry to the log
void add_log_entry(Log *log, const char *level, const char *message) {
    if (log->count < MAX_LOG_ENTRIES) {
        // Get the current time and format it
        time_t now = time(NULL);
        strftime(log->entries[log->count].timestamp, sizeof(log->entries[log->count].timestamp), TIME_FORMAT, localtime(&now));

        // Copy the log level and message
        snprintf(log->entries[log->count].level, sizeof(log->entries[log->count].level), "%s", level);
        snprintf(log->entries[log->count].message, sizeof(log->entries[log->count].message), "%s", message);

        log->count++;
    } else {
        printf("Log is full! Cannot add more entries.\n");
    }
}

// Function to print all the log entries
void print_logs(const Log *log) {
    for (int i = 0; i < log->count; i++) {
        printf("[%s] [%s]: %s\n", log->entries[i].timestamp, log->entries[i].level, log->entries[i].message);
    }
}

// Function to filter and print log entries by level
void filter_logs_by_level(const Log *log, const char *level) {
    for (int i = 0; i < log->count; i++) {
        if (strcmp(log->entries[i].level, level) == 0) {
            printf("[%s] [%s]: %s\n", log->entries[i].timestamp, log->entries[i].level, log->entries[i].message);
        }
    }
}