//GEMINI-pro DATASET v1.0 Category: Graph Coloring Problem ; Style: cheerful
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

// Number of colors
#define COLORS 3

// Number of vertices
#define VERTICES 4

// Graph represented as an adjacency matrix
int graph[VERTICES][VERTICES] = {
    {0, 1, 1, 0},
    {1, 0, 1, 1},
    {1, 1, 0, 1},
    {0, 1, 1, 0}
};

// Function to check if a color is safe to use at a particular vertex
bool isSafe(int v, int color, int graph[VERTICES][VERTICES]) {
    for (int i = 0; i < VERTICES; i++) {
        if (graph[v][i] && color == graph[i][i]) {
            return false;
        }
    }
    return true;
}

// Function to find a solution to the graph coloring problem
bool graphColoring(int v, int graph[VERTICES][VERTICES], int colors[VERTICES]) {
    if (v == VERTICES) {
        return true;
    }

    for (int c = 1; c <= COLORS; c++) {
        if (isSafe(v, c, graph)) {
            colors[v] = c;
            if (graphColoring(v + 1, graph, colors)) {
                return true;
            }
            colors[v] = 0;
        }
    }

    return false;
}

// Function to print the solution
void printSolution(int colors[VERTICES]) {
    printf("Vertex  Color\n");
    for (int i = 0; i < VERTICES; i++) {
        printf("%d      %d\n", i, colors[i]);
    }
}

int main() {
    int colors[VERTICES] = {0};

    if (graphColoring(0, graph, colors)) {
        printSolution(colors);
    } else {
        printf("No solution exists");
    }

    return 0;
}