//Gemma-7B DATASET v1.0 Category: Cafe Billing System ; Style: curious
#include <stdio.h>
#include <stdlib.h>

#define MAX_ITEMS 10

typedef struct Item {
    char name[20];
    int quantity;
    double price;
} Item;

Item items[MAX_ITEMS];

void initializeItems() {
    for (int i = 0; i < MAX_ITEMS; i++) {
        items[i].name[0] = '\0';
        items[i].quantity = 0;
        items[i].price = 0.0;
    }
}

void addItem(char *name, int quantity, double price) {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] == '\0') {
            strcpy(items[i].name, name);
            items[i].quantity = quantity;
            items[i].price = price;
            return;
        }
    }

    printf("Error: item limit exceeded!\n");
}

double calculateTotal() {
    double total = 0.0;
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] != '\0') {
            total += items[i].quantity * items[i].price;
        }
    }
    return total;
}

int main() {
    initializeItems();

    addItem("Coffee", 5, 2.0);
    addItem("Tea", 3, 1.5);
    addItem("Juice", 2, 1.2);

    double total = calculateTotal();

    printf("Total: %.2lf\n", total);

    return 0;
}