//Falcon-180B DATASET v1.0 Category: RAM usage monitor ; Style: irregular
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PROCESSES 100

typedef struct {
    int pid;
    char name[16];
    int ram_usage;
} Process;

int num_processes = 0;
Process processes[MAX_PROCESSES];

void add_process(int pid, char *name, int ram_usage) {
    if (num_processes >= MAX_PROCESSES) {
        printf("Error: Maximum number of processes reached.\n");
        return;
    }

    Process *p = &processes[num_processes];
    p->pid = pid;
    strcpy(p->name, name);
    p->ram_usage = ram_usage;

    num_processes++;
}

void remove_process(int pid) {
    int i;
    for (i = 0; i < num_processes; i++) {
        if (processes[i].pid == pid) {
            num_processes--;
            break;
        }
    }
}

void update_ram_usage(int pid, int new_ram_usage) {
    int i;
    for (i = 0; i < num_processes; i++) {
        if (processes[i].pid == pid) {
            processes[i].ram_usage = new_ram_usage;
            break;
        }
    }
}

void print_processes() {
    printf("PID\tName\tRAM usage (KB)\n");
    for (int i = 0; i < num_processes; i++) {
        printf("%d\t%s\t%d\n", processes[i].pid, processes[i].name, processes[i].ram_usage);
    }
}

int main() {
    add_process(1, "init", 100);
    add_process(2, "bash", 200);
    add_process(3, "vim", 300);

    print_processes();

    remove_process(2);

    print_processes();

    update_ram_usage(1, 150);

    print_processes();

    return 0;
}