//LLAMA2-13B DATASET v1.0 Category: Networking ; Style: grateful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define MAX_CLIENT_LENGTH 1024
#define MAX_SERVER_LENGTH 1024

int main(int argc, char *argv[]) {

  // Create a socket
  int server_fd = socket(AF_INET, SOCK_STREAM, 0);
  if (server_fd < 0) {
    perror("socket failed");
    exit(1);
  }

  // Set address and port number
  struct sockaddr_in server_addr;
  server_addr.sin_family = AF_INET;
  server_addr.sin_addr.s_addr = INADDR_ANY;
  server_addr.sin_port = htons(1234);

  // Bind the socket to the address and port
  if (bind(server_fd, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
    perror("bind failed");
    exit(1);
  }

  // Listen for incoming connections
  if (listen(server_fd, 3) < 0) {
    perror("listen failed");
    exit(1);
  }

  printf("Server listening on port %d...\n", server_addr.sin_port);

  // Accept an incoming connection
  int client_fd = accept(server_fd, NULL, NULL);
  if (client_fd < 0) {
    perror("accept failed");
    exit(1);
  }

  // Greet the client
  char greet[] = "Hello, dear client! I'm so grateful to have you here!";
  send(client_fd, greet, strlen(greet), 0);

  // Receive data from the client
  char buffer[MAX_CLIENT_LENGTH];
  recv(client_fd, buffer, MAX_CLIENT_LENGTH, 0);

  // Print the received message
  printf("Client message: %s\n", buffer);

  // Send a thank-you message to the client
  char thank_you[] = "Thank you so much for connecting! It means the world to me!";
  send(client_fd, thank_you, strlen(thank_you), 0);

  // Close the socket
  close(client_fd);

  return 0;
}