//Gemma-7B DATASET v1.0 Category: URL Sanitizer ; Style: detailed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_URL_LEN 256

void sanitize_url(char *url)
{
    char *p = url;
    char *q = url;
    int flag = 0;

    // Normalize the URL by converting uppercase letters to lowercase
    while (*p)
    {
        *p = tolower(*p);
        p++;
    }

    // Remove special characters
    while (*q)
    {
        if (!isalnum(*q) && *q != '-' && *q != '_')
        {
            flag = 1;
            *q = '\0';
        }
        else
        {
            q++;
        }
    }

    // If flag is set, the URL has been sanitized
    if (flag)
    {
        printf("Sanitized URL: %s\n", url);
    }
    else
    {
        printf("The URL is already sanitized: %s\n", url);
    }
}

int main()
{
    char url[MAX_URL_LEN] = "This is an example URL with special characters!#!$%^&*";

    sanitize_url(url);

    return 0;
}