//GPT-4o-mini DATASET v1.0 Category: Matrix operations ; Style: imaginative
#include <stdio.h>
#include <stdlib.h>

#define SIZE 3 // Define the size of the matrix for simplicity

void displayMatrix(int matrix[SIZE][SIZE]) {
    printf("The mystical matrix is:\n");
    for (int i = 0; i < SIZE; i++) {
        for (int j = 0; j < SIZE; j++) {
            printf("%d ", matrix[i][j]);
        }
        printf("\n");
    }
}

void addMatrices(int a[SIZE][SIZE], int b[SIZE][SIZE], int result[SIZE][SIZE]) {
    printf("Adding matrices... The result is:\n");
    for (int i = 0; i < SIZE; i++) {
        for (int j = 0; j < SIZE; j++) {
            result[i][j] = a[i][j] + b[i][j];
        }
    }
    displayMatrix(result);
}

void multiplyMatrices(int a[SIZE][SIZE], int b[SIZE][SIZE], int result[SIZE][SIZE]) {
    printf("Multiplying matrices... The result is:\n");
    for (int i = 0; i < SIZE; i++) {
        for (int j = 0; j < SIZE; j++) {
            result[i][j] = 0; // Initialize to 0
            for (int k = 0; k < SIZE; k++) {
                result[i][j] += a[i][k] * b[k][j];
            }
        }
    }
    displayMatrix(result);
}

void transposeMatrix(int matrix[SIZE][SIZE], int result[SIZE][SIZE]) {
    printf("Transposing the matrix... The result is:\n");
    for (int i = 0; i < SIZE; i++) {
        for (int j = 0; j < SIZE; j++) {
            result[j][i] = matrix[i][j];
        }
    }
    displayMatrix(result);
}

int determinant(int matrix[SIZE][SIZE]) {
    int det = 0;
    det = matrix[0][0]*(matrix[1][1]*matrix[2][2]-matrix[1][2]*matrix[2][1]) 
        - matrix[0][1]*(matrix[1][0]*matrix[2][2]-matrix[1][2]*matrix[2][0]) 
        + matrix[0][2]*(matrix[1][0]*matrix[2][1]-matrix[1][1]*matrix[2][0]);
    return det;
}

int main() {
    // Just as the fates wove, our hero prepares his matrices for battle!
    int matrixA[SIZE][SIZE] = {{1, 2, 3}, {4, 5, 6}, {7, 8, 9}};
    int matrixB[SIZE][SIZE] = {{9, 8, 7}, {6, 5, 4}, {3, 2, 1}};
    int result[SIZE][SIZE];
    int transposed[SIZE][SIZE];

    printf("Welcome to the Matrix Realm!\n\n");
    
    // Displaying the initial matrices
    printf("Matrix A:\n");
    displayMatrix(matrixA);
    printf("Matrix B:\n");
    displayMatrix(matrixB);

    // The hero adds the matrices together
    addMatrices(matrixA, matrixB, result);

    // The battle intensifies with multiplication!
    multiplyMatrices(matrixA, matrixB, result);

    // The transmutation of the main matrix occurs next!
    transposeMatrix(matrixA, transposed);

    // Revealing the magic of determinants 
    printf("The determinants of Matrix A is: %d\n", determinant(matrixA));
    printf("The determinants of Matrix B is: %d\n", determinant(matrixB));

    printf("\nThe war against chaos continues with matrices as our weapon!\n");
    return 0;
}