//Falcon2-11B DATASET v1.0 Category: Hotel Management System ; Style: protected
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Structure to represent a hotel room
struct Room {
    int roomNumber;
    char roomType[50];
    float pricePerNight;
};

// Function to add a new room to the hotel
void addRoom(struct Room* rooms, int numRooms, int roomNumber, char* roomType, float price) {
    if (roomNumber < 0 || roomNumber >= numRooms) {
        printf("Invalid room number\n");
        return;
    }

    strncpy(rooms[roomNumber].roomType, roomType, sizeof(rooms[roomNumber].roomType));
    rooms[roomNumber].pricePerNight = price;
}

// Function to remove a room from the hotel
void removeRoom(struct Room* rooms, int numRooms, int roomNumber) {
    if (roomNumber < 0 || roomNumber >= numRooms) {
        printf("Invalid room number\n");
        return;
    }

    free(rooms[roomNumber].roomType);
    free(rooms[roomNumber].roomType);
}

// Function to display all rooms in the hotel
void displayRooms(struct Room* rooms, int numRooms) {
    for (int i = 0; i < numRooms; i++) {
        printf("Room %d: Type: %s, Price: $%.2f\n", i+1, rooms[i].roomType, rooms[i].pricePerNight);
    }
}

int main() {
    // Create an array to store room information
    struct Room rooms[10];
    int numRooms = sizeof(rooms) / sizeof(rooms[0]);

    // Add some rooms to the hotel
    addRoom(rooms, numRooms, 101, "Standard", 100.0);
    addRoom(rooms, numRooms, 102, "Deluxe", 150.0);
    addRoom(rooms, numRooms, 103, "Suite", 200.0);

    // Display all rooms in the hotel
    displayRooms(rooms, numRooms);

    // Remove a room from the hotel
    removeRoom(rooms, numRooms, 101);

    // Display all rooms in the hotel after removing the room
    displayRooms(rooms, numRooms);

    return 0;
}