//Falcon-180B DATASET v1.0 Category: Network Topology Mapper ; Style: introspective
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <time.h>

#define MAX_NODES 100
#define MAX_EDGES 200

typedef struct {
    int id;
    char name[20];
    double x, y;
} Node;

typedef struct {
    int src, dst;
    double weight;
} Edge;

int num_nodes = 0, num_edges = 0;
Node nodes[MAX_NODES];
Edge edges[MAX_EDGES];

void add_node(int id, char *name, double x, double y) {
    if (num_nodes >= MAX_NODES) {
        printf("Error: Maximum number of nodes reached.\n");
        return;
    }
    strcpy(nodes[num_nodes].name, name);
    nodes[num_nodes].id = id;
    nodes[num_nodes].x = x;
    nodes[num_nodes].y = y;
    num_nodes++;
}

void add_edge(int src, int dst, double weight) {
    if (num_edges >= MAX_EDGES) {
        printf("Error: Maximum number of edges reached.\n");
        return;
    }
    edges[num_edges].src = src;
    edges[num_edges].dst = dst;
    edges[num_edges].weight = weight;
    num_edges++;
}

void print_nodes() {
    printf("Nodes:\n");
    for (int i = 0; i < num_nodes; i++) {
        printf("%d: %s (%lf, %lf)\n", nodes[i].id, nodes[i].name, nodes[i].x, nodes[i].y);
    }
}

void print_edges() {
    printf("Edges:\n");
    for (int i = 0; i < num_edges; i++) {
        printf("%d -> %d (%lf)\n", edges[i].src, edges[i].dst, edges[i].weight);
    }
}

int main() {
    // Example usage
    add_node(1, "Node A", 0.0, 0.0);
    add_node(2, "Node B", 1.0, 0.0);
    add_node(3, "Node C", 2.0, 0.0);
    add_node(4, "Node D", 3.0, 0.0);
    add_edge(1, 2, 1.0);
    add_edge(2, 3, 2.0);
    add_edge(3, 4, 3.0);
    add_edge(4, 1, 4.0);
    print_nodes();
    print_edges();
    return 0;
}