//Gemma-7B DATASET v1.0 Category: Network Quality of Service (QoS) monitor ; Style: standalone
#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>
#include <sys/socket.h>
#include <unistd.h>
#include <pthread.h>

#define MAX_PACKET_SIZE 1024
#define LISTEN_PORT 50000
#define SERVER_IP "192.168.1.1"

typedef struct QoS_Packet {
    int sequence_number;
    int packet_size;
    double arrival_time;
    double processing_time;
} QoS_Packet;

void send_qos_packet(QoS_Packet* packet) {
    int sockfd = socket(AF_INET, SOCK_STREAM, htons(5));
    struct sockaddr_in server_addr;
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = LISTEN_PORT;
    server_addr.sin_addr.s_addr = inet_addr(SERVER_IP);

    if (connect(sockfd, (struct sockaddr*)&server_addr, sizeof(server_addr)) == -1) {
        perror("Error connecting to server");
        exit(1);
    }

    // Send packet data
    write(sockfd, packet, sizeof(*packet));

    // Close socket
    close(sockfd);
}

void receive_qos_packet(QoS_Packet* packet) {
    int sockfd = socket(AF_INET, SOCK_STREAM, htons(5));
    struct sockaddr_in server_addr;
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = LISTEN_PORT;
    server_addr.sin_addr.s_addr = inet_addr(SERVER_IP);

    if (connect(sockfd, (struct sockaddr*)&server_addr, sizeof(server_addr)) == -1) {
        perror("Error connecting to server");
        exit(1);
    }

    // Receive packet data
    read(sockfd, packet, sizeof(*packet));

    // Close socket
    close(sockfd);
}

int main() {
    QoS_Packet packet;
    packet.sequence_number = 1;
    packet.packet_size = MAX_PACKET_SIZE;
    packet.arrival_time = 0.0;
    packet.processing_time = 0.0;

    send_qos_packet(&packet);
    receive_qos_packet(&packet);

    // Print packet data
    printf("Sequence number: %d\n", packet.sequence_number);
    printf("Packet size: %d\n", packet.packet_size);
    printf("Arrival time: %.2f\n", packet.arrival_time);
    printf("Processing time: %.2f\n", packet.processing_time);

    return 0;
}