//Gemma-7B DATASET v1.0 Category: Interprocess communication ; Style: careful
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/ipc.h>
#include <sys/msg.h>

#define IPC_KEY 1234

int main()
{
    int msg_id;
    struct msgbuf
    {
        long mtype;
        char data[1024];
    } message;

    // Create a message queue
    msg_id = msgget(IPC_KEY, IPC_CREAT | IPC_EXCL);
    if (msg_id == -1)
    {
        perror("Error creating message queue");
        exit(1);
    }

    // Send a message
    message.mtype = 1;
    strcpy(message.data, "Hello, world!");
    if (msgsnd(msg_id, &message, sizeof(message), 0) == -1)
    {
        perror("Error sending message");
        exit(1);
    }

    // Receive a message
    message.mtype = 0;
    if (msgrcv(msg_id, &message, sizeof(message), 0, 0) == -1)
    {
        perror("Error receiving message");
        exit(1);
    }

    // Print the received message
    printf("Received message: %s\n", message.data);

    // Destroy the message queue
    msgctl(msg_id, IPC_RMID, NULL);

    return 0;
}