//MISTRAL-7B DATASET v1.0 Category: Password Strength Checker ; Style: interoperable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

// Minimum length and requirements for a strong password
#define MIN_LENGTH 8
#define REQ_UPPER 1
#define REQ_LOWER 1
#define REQ_NUM 1
#define REQ_SPECIAL 1

// Function to check password strength
int check_password_strength(const char *password) {
    size_t len = strlen(password);
    int upper = 0, lower = 0, num = 0, special = 0;

    // Check password length
    if (len < MIN_LENGTH) {
        return 0;
    }

    // Check for uppercase letters
    for (size_t i = 0; password[i]; ++i) {
        if (isupper((unsigned char)password[i])) {
            upper++;
        }
    }
    if (!upper) {
        return REQ_UPPER != 0;
    }

    // Check for lowercase letters
    for (size_t i = 0; password[i]; ++i) {
        if (islower((unsigned char)password[i])) {
            lower++;
        }
    }
    if (!lower) {
        return REQ_LOWER != 0;
    }

    // Check for numbers
    for (size_t i = 0; password[i]; ++i) {
        if (isdigit((unsigned char)password[i])) {
            num++;
        }
    }
    if (!num) {
        return REQ_NUM != 0;
    }

    // Check for special characters
    for (size_t i = 0; password[i]; ++i) {
        if (!isalnum((unsigned char)password[i]) && !isspace((unsigned char)password[i])) {
            special++;
            break;
        }
    }
    if (!special) {
        return REQ_SPECIAL != 0;
    }

    // Password meets all requirements
    return 1;
}

// Test the password strength checker function
int main(void) {
    const char *passwords[] = {
        "Password123",
        "P@ssw0rd",
        "MySecretPassword",
        "ThisIsAStrongPassword1!",
        "password",
        "12345678",
        "qwerty",
        "ABCDEFGHIJKLMNOPQRSTUVWXYZ",
        "!@#$%^&*()_+-=[]{}|\\:;\"'<>,.?/~`"
    };

    for (size_t i = 0; i < sizeof(passwords) / sizeof(passwords[0]); ++i) {
        int strength = check_password_strength(passwords[i]);
        printf("Password \"%s\" has a strength of %d.\n", passwords[i], strength);
    }

    return 0;
}