//Falcon2-11B DATASET v1.0 Category: Remote control Vehicle Simulation ; Style: sophisticated
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_DISTANCE 500

typedef struct {
    int x;
    int y;
    int z;
} point_t;

typedef struct {
    point_t pos;
    point_t vel;
    point_t acc;
} rc_vehicle_t;

void rc_vehicle_init(rc_vehicle_t* v) {
    v->pos.x = 0;
    v->pos.y = 0;
    v->pos.z = 0;

    v->vel.x = 0;
    v->vel.y = 0;
    v->vel.z = 0;

    v->acc.x = 0;
    v->acc.y = 0;
    v->acc.z = 0;
}

void rc_vehicle_move(rc_vehicle_t* v, int distance) {
    v->pos.x += v->vel.x * distance;
    v->pos.y += v->vel.y * distance;
    v->pos.z += v->vel.z * distance;

    v->vel.x += v->acc.x * distance;
    v->vel.y += v->acc.y * distance;
    v->vel.z += v->acc.z * distance;
}

void rc_vehicle_update(rc_vehicle_t* v) {
    v->acc.x = v->acc.y = v->acc.z = 0;
}

int main() {
    rc_vehicle_t v;
    rc_vehicle_init(&v);

    printf("Initial position: (%d, %d, %d)\n", v.pos.x, v.pos.y, v.pos.z);

    rc_vehicle_move(&v, MAX_DISTANCE);

    printf("Final position: (%d, %d, %d)\n", v.pos.x, v.pos.y, v.pos.z);

    rc_vehicle_update(&v);

    return 0;
}