//GEMINI-pro DATASET v1.0 Category: Educational ; Style: active
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the game board and player markers
#define BOARD_SIZE 3
char board[BOARD_SIZE][BOARD_SIZE];
#define PLAYER1 'X'
#define PLAYER2 'O'

// Function to check if a player has won
int check_win(char player) {
    // Check rows
    for (int i = 0; i < BOARD_SIZE; i++) {
        if (board[i][0] == player && board[i][1] == player && board[i][2] == player) {
            return 1;
        }
    }

    // Check columns
    for (int j = 0; j < BOARD_SIZE; j++) {
        if (board[0][j] == player && board[1][j] == player && board[2][j] == player) {
            return 1;
        }
    }

    // Check diagonals
    if (board[0][0] == player && board[1][1] == player && board[2][2] == player) {
        return 1;
    }
    if (board[0][2] == player && board[1][1] == player && board[2][0] == player) {
        return 1;
    }

    // No winner yet
    return 0;
}

// Function to get a random player
char get_random_player() {
    if (rand() % 2) {
        return PLAYER1;
    } else {
        return PLAYER2;
    }
}

// Function to make a move for a player
void make_move(char player) {
    int x, y;

    // Get a random move until a valid one is found
    do {
        x = rand() % BOARD_SIZE;
        y = rand() % BOARD_SIZE;
    } while (board[x][y] != ' ');

    // Place the player's marker on the board
    board[x][y] = player;
}

// Function to print the game board
void print_board() {
    for (int i = 0; i < BOARD_SIZE; i++) {
        printf(" %c | %c | %c ", board[i][0], board[i][1], board[i][2]);
        if (i < BOARD_SIZE - 1) {
            printf("\n---|---|---\n");
        }
    }
}

// Main function
int main() {
    // Initialize the random number generator
    srand((unsigned) time(NULL));

    // Initialize the game board
    for (int i = 0; i < BOARD_SIZE; i++) {
        for (int j = 0; j < BOARD_SIZE; j++) {
            board[i][j] = ' ';
        }
    }

    // Get the first player
    char player = get_random_player();

    // Play the game until a winner is found or the board is full
    while (!check_win(PLAYER1) && !check_win(PLAYER2) && board[0][0] != PLAYER1 && board[0][0] != PLAYER2 && board[0][1] != PLAYER1 && board[0][1] != PLAYER2 && board[0][2] != PLAYER1 && board[0][2] != PLAYER2 && board[1][0] != PLAYER1 && board[1][0] != PLAYER2 && board[1][1] != PLAYER1 && board[1][1] != PLAYER2 && board[1][2] != PLAYER1 && board[1][2] != PLAYER2 && board[2][0] != PLAYER1 && board[2][0] != PLAYER2 && board[2][1] != PLAYER1 && board[2][1] != PLAYER2 && board[2][2] != PLAYER1 && board[2][2] != PLAYER2) {
        // Print the game board
        print_board();

        // Make a move for the current player
        make_move(player);

        // Switch to the other player
        player = player == PLAYER1 ? PLAYER2 : PLAYER1;
    }

    // Print the game board
    print_board();

    // Check if there is a winner
    if (check_win(PLAYER1)) {
        printf("Player 1 wins!\n");
    } else if (check_win(PLAYER2)) {
        printf("Player 2 wins!\n");
    } else {
        printf("Tie!\n");
    }

    return 0;
}