//GPT-4o-mini DATASET v1.0 Category: Syntax parsing ; Style: puzzling
#include <stdio.h>

#define MAX_TOKENS 100

typedef enum {
    TOKEN_NUMBER,
    TOKEN_IDENTIFIER,
    TOKEN_OPERATOR,
    TOKEN_SEMICOLON,
    TOKEN_UNKNOWN
} TokenType;

typedef struct {
    TokenType type;
    char value[32];
} Token;

Token tokens[MAX_TOKENS];
int tokenCount = 0;

void printTokens() {
    for (int i = 0; i < tokenCount; i++) {
        switch (tokens[i].type) {
            case TOKEN_NUMBER:
                printf("Token[%d]: NUMBER - %s\n", i, tokens[i].value);
                break;
            case TOKEN_IDENTIFIER:
                printf("Token[%d]: IDENTIFIER - %s\n", i, tokens[i].value);
                break;
            case TOKEN_OPERATOR:
                printf("Token[%d]: OPERATOR - %s\n", i, tokens[i].value);
                break;
            case TOKEN_SEMICOLON:
                printf("Token[%d]: SEMICOLON\n", i);
                break;
            default:
                printf("Token[%d]: UNKNOWN\n", i);
        }
    }
}

int isDigit(char c) {
    return c >= '0' && c <= '9';
}

int isAlpha(char c) {
    return (c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z');
}

int isOperator(char c) {
    return c == '+' || c == '-' || c == '*' || c == '/';
}

void tokenize(const char *source) {
    while (*source) {
        if (isDigit(*source)) {
            Token token;
            int idx = 0;
            while (isDigit(*source) && idx < 31) {
                token.value[idx++] = *source++;
            }
            token.value[idx] = '\0';
            token.type = TOKEN_NUMBER;
            tokens[tokenCount++] = token;

        } else if (isAlpha(*source)) {
            Token token;
            int idx = 0;
            while (isAlpha(*source) || isDigit(*source)) {
                token.value[idx++] = *source++;
            }
            token.value[idx] = '\0';
            token.type = TOKEN_IDENTIFIER;
            tokens[tokenCount++] = token;

        } else if (isOperator(*source)) {
            Token token;
            token.value[0] = *source++;
            token.value[1] = '\0';
            token.type = TOKEN_OPERATOR;
            tokens[tokenCount++] = token;

        } else if (*source == ';') {
            Token token;
            token.type = TOKEN_SEMICOLON;
            tokens[tokenCount++] = token;
            source++;
        } else {
            source++;
        }
    }
}

void parse() {
    for (int i = 0; i < tokenCount; i++) {
        if (tokens[i].type == TOKEN_NUMBER) {
            printf("Parsing number: %s\n", tokens[i].value);
        } else if (tokens[i].type == TOKEN_IDENTIFIER) {
            printf("Parsing identifier: %s\n", tokens[i].value);
        } else if (tokens[i].type == TOKEN_OPERATOR) {
            printf("Parsing operator: %s\n", tokens[i].value);
        } else if (tokens[i].type == TOKEN_SEMICOLON) {
            printf("Parsing statement end\n");
        } else {
            printf("Unknown token encountered\n");
        }
    }
}

int main() {
    const char *source = "int a = 5; float b = 10.5; a + b;";
    tokenize(source);
    printTokens();
    parse();
    
    return 0;
}