//Gemma-7B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: optimized
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_PROCESS 5
#define MAX_Quantum 10

typedef struct Process
{
    int id;
    int arrivalTime;
    int burstTime;
    int remainingTime;
} Process;

void scheduler(Process *processes, int numProcesses)
{
    int time = 0;
    int quantum = MAX_Quantum;
    int completed = 0;

    while (!completed)
    {
        int i = 0;
        for (i = 0; i < numProcesses; i++)
        {
            if (processes[i].remainingTime > 0 && processes[i].arrivalTime <= time)
            {
                processes[i].remainingTime--;
                quantum--;

                if (processes[i].remainingTime == 0)
                {
                    completed++;
                    printf("Process %d completed at time %d\n", processes[i].id, time);
                }
            }
        }

        time++;

        if (quantum == 0)
        {
            quantum = MAX_Quantum;
            time++;
        }
    }

    printf("All processes completed\n");
}

int main()
{
    Process processes[MAX_PROCESS];

    // Populate the processes
    processes[0].id = 0;
    processes[0].arrivalTime = 0;
    processes[0].burstTime = 5;
    processes[0].remainingTime = processes[0].burstTime;

    processes[1].id = 1;
    processes[1].arrivalTime = 2;
    processes[1].burstTime = 3;
    processes[1].remainingTime = processes[1].burstTime;

    processes[2].id = 2;
    processes[2].arrivalTime = 4;
    processes[2].burstTime = 4;
    processes[2].remainingTime = processes[2].burstTime;

    processes[3].id = 3;
    processes[3].arrivalTime = 6;
    processes[3].burstTime = 2;
    processes[3].remainingTime = processes[3].burstTime;

    processes[4].id = 4;
    processes[4].arrivalTime = 8;
    processes[4].burstTime = 3;
    processes[4].remainingTime = processes[4].burstTime;

    scheduler(processes, MAX_PROCESS);

    return 0;
}