//Gemma-7B DATASET v1.0 Category: Bingo Simulator ; Style: light-weight
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_NUM_BALLS 10
#define MAX_NUM_ROWS 5
#define MAX_NUM_COLS 5

int main()
{
  // Seed the random number generator
  srand(time(NULL));

  // Create a bingo card
  int bingoCard[MAX_NUM_ROWS][MAX_NUM_COLS] = {{0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0}};

  // Generate balls
  int balls[MAX_NUM_BALLS] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

  // Draw the balls
  for (int i = 0; i < MAX_NUM_BALLS; i++)
  {
    balls[i] = rand() % MAX_NUM_BALLS + 1;
  }

  // Check for bingo
  for (int r = 0; r < MAX_NUM_ROWS; r++)
  {
    for (int c = 0; c < MAX_NUM_COLS; c++)
    {
      for (int i = 0; i < MAX_NUM_BALLS; i++)
      {
        if (bingoCard[r][c] == balls[i])
        {
          bingoCard[r][c] = -1;
        }
      }
    }
  }

  // Print the results
  printf("Your bingo card:\n");
  for (int r = 0; r < MAX_NUM_ROWS; r++)
  {
    for (int c = 0; c < MAX_NUM_COLS; c++)
    {
      printf("%d ", bingoCard[r][c]);
    }
    printf("\n");
  }

  printf("You have won! Congratulations!");

  return 0;
}