//Falcon-180B DATASET v1.0 Category: Bitwise operations ; Style: sophisticated
#include <stdio.h>
#include <stdlib.h>

// Function to swap two numbers without using a third variable
void swap(int* a, int* b) {
    *a ^= *b;
    *b ^= *a;
    *a ^= *b;
}

// Function to reverse a string without using any built-in functions
void reverseString(char* str, int length) {
    for (int i = 0; i < length / 2; i++) {
        char temp = str[i];
        str[i] = str[length - i - 1];
        str[length - i - 1] = temp;
    }
}

// Function to check if a number is a power of 2
int isPowerOfTwo(int n) {
    if (n <= 0) {
        return 0;
    }
    while (n > 1) {
        if (n % 2!= 0) {
            return 0;
        }
        n /= 2;
    }
    return 1;
}

int main() {
    int num1 = 5, num2 = 7;
    printf("Before swapping: num1 = %d, num2 = %d\n", num1, num2);
    swap(&num1, &num2);
    printf("After swapping: num1 = %d, num2 = %d\n", num1, num2);

    char str[] = "Hello, World!";
    int length = strlen(str);
    printf("Original string: %s\n", str);
    reverseString(str, length);
    printf("Reversed string: %s\n", str);

    int n = 8;
    if (isPowerOfTwo(n)) {
        printf("%d is a power of 2.\n", n);
    } else {
        printf("%d is not a power of 2.\n", n);
    }

    return 0;
}