//Gemma-7B DATASET v1.0 Category: Simple Web Server ; Style: Linus Torvalds
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <netdb.h>

int main() {
  int sockfd, newsockfd, portno = 8080;
  char buffer[1024];
  struct sockaddr_in serv_addr, cli_addr;
  int clilen;

  // Socket setup
  sockfd = socket(AF_INET, SOCK_STREAM, htons(6));
  if (sockfd < 0) {
    perror("Error creating socket");
    exit(1);
  }

  // Bind to port
  serv_addr.sin_family = AF_INET;
  serv_addr.sin_port = htons(portno);
  if (bind(sockfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) < 0) {
    perror("Error binding socket");
    exit(1);
  }

  // Listen for clients
  listen(sockfd, &clilen);

  // Accept client connection
  newsockfd = accept(sockfd, (struct sockaddr *)&cli_addr, &clilen);
  if (newsockfd < 0) {
    perror("Error accepting client connection");
    exit(1);
  }

  // Receive client message
  recv(newsockfd, buffer, 1024, 0);
  printf("Client: %s\n", buffer);

  // Send server response
  strcpy(buffer, "Hello, client!");
  send(newsockfd, buffer, strlen(buffer), 0);

  // Close client connection
  close(newsockfd);

  // Close server socket
  close(sockfd);

  return 0;
}