//Falcon2-11B DATASET v1.0 Category: Stock market tracker ; Style: mathematical
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// Function to calculate the average stock price
double calculateAveragePrice(double* prices, int num_prices) {
    double total = 0;
    for (int i = 0; i < num_prices; i++) {
        total += prices[i];
    }
    return total / num_prices;
}

// Function to find the highest and lowest stock prices
void findMaxMin(double* prices, int num_prices, double* max_price, double* min_price) {
    double max = prices[0];
    double min = prices[0];
    for (int i = 0; i < num_prices; i++) {
        if (prices[i] > max) {
            max = prices[i];
        }
        if (prices[i] < min) {
            min = prices[i];
        }
    }
    *max_price = max;
    *min_price = min;
}

// Function to calculate the percentage change in stock price
double calculatePercentChange(double current_price, double previous_price) {
    return (current_price - previous_price) / previous_price * 100;
}

int main() {
    int num_prices = 5;
    double prices[num_prices];

    // Initialize stock prices
    prices[0] = 100.0;
    prices[1] = 120.0;
    prices[2] = 110.0;
    prices[3] = 130.0;
    prices[4] = 140.0;

    // Calculate average price
    double avg_price = calculateAveragePrice(prices, num_prices);
    printf("Average stock price: %.2f\n", avg_price);

    // Find maximum and minimum prices
    double max_price = 0;
    double min_price = 10000;
    findMaxMin(prices, num_prices, &max_price, &min_price);
    printf("Max stock price: %.2f\n", max_price);
    printf("Min stock price: %.2f\n", min_price);

    // Calculate percentage change in stock price
    double previous_price = prices[0];
    for (int i = 1; i < num_prices; i++) {
        double current_price = prices[i];
        double percent_change = calculatePercentChange(current_price, previous_price);
        printf("Percent change in price: %.2f%%\n", percent_change);
        previous_price = current_price;
    }

    return 0;
}