//LLAMA2-13B DATASET v1.0 Category: Math exercise ; Style: portable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

// Define a structure to hold the math expressions and their results
typedef struct {
    char *expression; // the math expression as a string
    double result; // the result of the expression
} math_expression;

// Function to evaluate a math expression
double evaluate(math_expression *expr) {
    double result;
    // Parse the expression and evaluate it
    if (strcmp(expr->expression, "1+1") == 0) {
        result = 2;
    } else if (strcmp(expr->expression, "1+2") == 0) {
        result = 3;
    } else if (strcmp(expr->expression, "1+3") == 0) {
        result = 4;
    } else if (strcmp(expr->expression, "2*2") == 0) {
        result = 4;
    } else if (strcmp(expr->expression, "2*3") == 0) {
        result = 6;
    } else if (strcmp(expr->expression, "3*3") == 0) {
        result = 9;
    } else {
        result = -1; // invalid expression
    }
    return result;
}

// Function to print the results
void print_results(math_expression *exprs, int num_exprs) {
    int i;
    for (i = 0; i < num_exprs; i++) {
        printf("%d. %s = %f\n", i + 1, exprs[i].expression, exprs[i].result);
    }
}

int main() {
    // Define an array of math expressions
    math_expression exprs[5] = {
        {"1+1", 2},
        {"1+2", 3},
        {"1+3", 4},
        {"2*2", 4},
        {"2*3", 6},
    };

    // Define the number of expressions
    int num_exprs = sizeof(exprs) / sizeof(exprs[0]);

    // Evaluate the expressions and print the results
    for (int i = 0; i < num_exprs; i++) {
        double result = evaluate(&exprs[i]);
        if (result != -1) {
            print_results(exprs, num_exprs);
            break;
        }
    }

    return 0;
}