//Gemma-7B DATASET v1.0 Category: Cafe Billing System ; Style: introspective
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 10

typedef struct Item {
    char name[50];
    int quantity;
    float price;
} Item;

Item items[MAX_ITEMS];

void addItem(char name[], int quantity, float price) {
    int i = 0;
    for (i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] == '\0') {
            strcpy(items[i].name, name);
            items[i].quantity = quantity;
            items[i].price = price;
            return;
        }
    }

    printf("Error: Inventory is full.\n");
}

void displayItems() {
    int i = 0;
    for (i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] != '\0') {
            printf("%s - %d - %.2f\n", items[i].name, items[i].quantity, items[i].price);
        }
    }
}

void calculateTotal() {
    int i = 0;
    float total = 0.0f;
    for (i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] != '\0') {
            total += items[i].quantity * items[i].price;
        }
    }

    printf("Total: %.2f\n", total);
}

int main() {
    addItem("Coffee", 10, 2.50);
    addItem("Tea", 5, 3.00);
    addItem("Juice", 7, 2.00);

    displayItems();

    calculateTotal();

    return 0;
}