//LLAMA2-13B DATASET v1.0 Category: Error handling ; Style: protected
#include <stdio.h>
#include <stdlib.h>

#define MAX_ACCOUNT_NUMBER 100
#define MIN_DEPOSIT 100
#define MAX_WITHDRAW 500

typedef struct {
    int account_number;
    double balance;
} account_t;

account_t accounts[MAX_ACCOUNT_NUMBER];
int num_accounts = 0;

void init_accounts() {
    int i;
    for (i = 0; i < MAX_ACCOUNT_NUMBER; i++) {
        accounts[i].account_number = i;
        accounts[i].balance = 0;
    }
}

void deposit(int account_number, double amount) {
    if (amount < MIN_DEPOSIT) {
        fprintf(stderr, "Error: Deposit amount must be at least %f\n", MIN_DEPOSIT);
        return;
    }
    if (account_number < 0 || account_number >= MAX_ACCOUNT_NUMBER) {
        fprintf(stderr, "Error: Invalid account number\n");
        return;
    }
    accounts[account_number].balance += amount;
    printf("Deposit %f to account %d successful\n", amount, account_number);
}

void withdraw(int account_number, double amount) {
    if (amount > accounts[account_number].balance) {
        fprintf(stderr, "Error: Insufficient balance\n");
        return;
    }
    accounts[account_number].balance -= amount;
    printf("Withdraw %f from account %d successful\n", amount, account_number);
}

int main() {
    init_accounts();

    // Test cases
    deposit(1, 100);
    deposit(2, 200);
    withdraw(1, 50);
    withdraw(2, 300);

    // Clean up
    for (int i = 0; i < MAX_ACCOUNT_NUMBER; i++) {
        if (accounts[i].balance < 0) {
            fprintf(stderr, "Error: Account %d has negative balance\n", i);
            return 1;
        }
    }

    return 0;
}