//Falcon-180B DATASET v1.0 Category: Medical Store Management System ; Style: irregular
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 100
#define MAX_CUSTOMERS 100

typedef struct {
    int id;
    char name[50];
    char address[100];
    int phone_number;
} Customer;

typedef struct {
    int id;
    char name[50];
    int quantity;
    double price;
} Item;

void add_customer(Customer* customers, int num_customers, Customer new_customer) {
    if (num_customers >= MAX_CUSTOMERS) {
        printf("Error: Cannot add more customers.\n");
        return;
    }
    memcpy(&customers[num_customers], &new_customer, sizeof(Customer));
    num_customers++;
}

void add_item(Item* items, int num_items, Item new_item) {
    if (num_items >= MAX_ITEMS) {
        printf("Error: Cannot add more items.\n");
        return;
    }
    memcpy(&items[num_items], &new_item, sizeof(Item));
    num_items++;
}

void print_customer(Customer customer) {
    printf("ID: %d\n", customer.id);
    printf("Name: %s\n", customer.name);
    printf("Address: %s\n", customer.address);
    printf("Phone number: %d\n", customer.phone_number);
}

void print_item(Item item) {
    printf("ID: %d\n", item.id);
    printf("Name: %s\n", item.name);
    printf("Quantity: %d\n", item.quantity);
    printf("Price: $%.2f\n", item.price);
}

void print_items(Item* items, int num_items) {
    for (int i = 0; i < num_items; i++) {
        print_item(items[i]);
    }
}

int main() {
    Customer customers[MAX_CUSTOMERS];
    int num_customers = 0;

    Customer new_customer = {.id = 1,.name = "John Doe",.address = "123 Main St.",.phone_number = 5551234 };
    add_customer(customers, num_customers, new_customer);

    Item items[MAX_ITEMS];
    int num_items = 0;

    Item new_item = {.id = 1,.name = "Aspirin",.quantity = 100,.price = 5.99 };
    add_item(items, num_items, new_item);

    print_items(items, num_items);

    return 0;
}