//Falcon-180B DATASET v1.0 Category: System event logger ; Style: sophisticated
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#define MAX_LOG_ENTRIES 100
#define LOG_FILE "event_log.txt"

typedef struct {
    char event_type[50];
    char description[200];
    time_t timestamp;
} log_entry;

FILE *log_file;
int num_entries = 0;

void initialize_log() {
    log_file = fopen(LOG_FILE, "a");
    if (log_file == NULL) {
        printf("Error: could not open log file.\n");
        exit(1);
    }
}

void write_log_entry(log_entry entry) {
    fprintf(log_file, "Event Type: %s\n", entry.event_type);
    fprintf(log_file, "Description: %s\n", entry.description);
    fprintf(log_file, "Timestamp: %s\n\n", ctime(&entry.timestamp));
}

void add_log_entry(char *event_type, char *description) {
    if (num_entries >= MAX_LOG_ENTRIES) {
        printf("Error: log is full.\n");
        return;
    }

    log_entry new_entry;
    strcpy(new_entry.event_type, event_type);
    strcpy(new_entry.description, description);
    new_entry.timestamp = time(NULL);

    write_log_entry(new_entry);
    num_entries++;
}

void close_log() {
    fclose(log_file);
}

int main() {
    initialize_log();

    add_log_entry("System Start", "Program initialized successfully.");

    // Example usage of event logging
    add_log_entry("Button Click", "User clicked the 'Save' button.");
    add_log_entry("Form Submit", "User submitted a form with the following data: Name=John Doe, Age=30");

    close_log();

    return 0;
}