//Falcon-180B DATASET v1.0 Category: Password management ; Style: Donald Knuth
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PASSWORDS 100
#define MAX_PASSWORD_LENGTH 80

typedef struct {
    char password[MAX_PASSWORD_LENGTH];
    int id;
} Password;

Password passwords[MAX_PASSWORDS];
int num_passwords = 0;

void add_password(char *password) {
    if (num_passwords >= MAX_PASSWORDS) {
        printf("Error: Maximum number of passwords reached.\n");
        return;
    }

    int id = num_passwords;
    strcpy(passwords[id].password, password);
    passwords[id].id = id;
    num_passwords++;
}

void delete_password(int id) {
    int i;
    for (i = 0; i < num_passwords; i++) {
        if (passwords[i].id == id) {
            memset(passwords[i].password, 0, sizeof(passwords[i].password));
            num_passwords--;
            break;
        }
    }
}

void print_passwords() {
    printf("ID\tPassword\n");
    for (int i = 0; i < num_passwords; i++) {
        printf("%d\t%s\n", passwords[i].id, passwords[i].password);
    }
}

int main() {
    add_password("password1");
    add_password("password2");
    add_password("password3");

    print_passwords();

    delete_password(1);

    print_passwords();

    return 0;
}