//LLAMA2-13B DATASET v1.0 Category: Networking ; Style: shocked
// Shocking Networking Program in C

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define PORT 8080

int main(void)
{
  // Shockingly, we're going to create a socket!
  int sock = socket(AF_INET, SOCK_STREAM, 0);
  if (sock < 0) {
    perror("Shockingly, socket creation failed!");
    exit(EXIT_FAILURE);
  }

  // OMG, we're going to bind the socket to a wildcard address!
  struct sockaddr_in server_addr = {
    .sin_family = AF_INET,
    .sin_port = htons(PORT),
    .sin_addr.s_addr = INADDR_ANY
  };
  if (bind(sock, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
    perror("Whoa, binding failed!");
    exit(EXIT_FAILURE);
  }

  // Gasp, we're going to listen for incoming connections!
  if (listen(sock, 3) < 0) {
    perror("Oh no, listening failed!");
    exit(EXIT_FAILURE);
  }

  printf("Shockingly, we're listening on port %d...\n", PORT);

  // Oh my gosh, an incoming connection!
  int client_sock = accept(sock, NULL, NULL);
  if (client_sock < 0) {
    perror("Oh no, accept failed!");
    exit(EXIT_FAILURE);
  }

  // Wow, let's send some data to the client!
  char message[] = "Hello, client!";
  send(client_sock, message, strlen(message), 0);

  // Oh my, the client sent something back!
  char buffer[1024];
  recv(client_sock, buffer, 1024, 0);
  printf("Client said: %s\n", buffer);

  // Gasp, the client closed the connection!
  if (close(client_sock) < 0) {
    perror("Whoa, closing the socket failed!");
  }

  // Finally, we're going to close the listening socket.
  if (close(sock) < 0) {
    perror("Oh no, closing the listening socket failed!");
  }

  return 0;
}