//Gemma-7B DATASET v1.0 Category: Cafe Billing System ; Style: distributed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define a structure for a coffee item
typedef struct CoffeeItem {
    char name[20];
    float price;
    int quantity;
} CoffeeItem;

// Define a function to calculate the total cost of an order
float calculateTotalCost(CoffeeItem *items, int numItems) {
    float totalCost = 0;
    for (int i = 0; i < numItems; i++) {
        totalCost += items[i].price * items[i].quantity;
    }
    return totalCost;
}

// Define a function to print the bill
void printBill(CoffeeItem *items, int numItems, float totalCost) {
    printf("--------------------------------------------------------\n");
    printf("C Cafe Billing System\n");
    printf("--------------------------------------------------------\n");
    printf("Items:\n");
    for (int i = 0; i < numItems; i++) {
        printf("%s - %d, $%.2f\n", items[i].name, items[i].quantity, items[i].price);
    }
    printf("Total Cost: $%.2f\n", totalCost);
    printf("--------------------------------------------------------\n");
    printf("Thank you for your order!\n");
    printf("--------------------------------------------------------\n");
}

int main() {
    // Create an array of coffee items
    CoffeeItem items[] = {
        {"Latte", 2.50, 2},
        {"Cappuccino", 3.00, 1},
        {"Americano", 1.50, 3}
    };

    // Calculate the total cost of the order
    float totalCost = calculateTotalCost(items, 3);

    // Print the bill
    printBill(items, 3, totalCost);

    return 0;
}